/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.standalone.rule;

import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.XMLProfileParser;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.global.ExtensionInstaller;
import org.sonarsource.sonarlint.core.container.global.ExtensionMatcher;
import org.sonarsource.sonarlint.core.container.global.ExtensionUtils;
import org.sonarsource.sonarlint.core.container.standalone.rule.RuleFinderCompatibility;
import org.sonarsource.sonarlint.core.container.standalone.rule.StandaloneActiveRulesProvider;
import org.sonarsource.sonarlint.core.container.standalone.rule.StandalonePluginRulesLoader;
import org.sonarsource.sonarlint.core.container.standalone.rule.StandaloneRulesProvider;

public class StandaloneRuleRepositoryContainer
extends ComponentContainer {
    private Rules rules;
    private ActiveRules activeRules;
    private RulesDefinition.Context ruleDefinitions;

    public StandaloneRuleRepositoryContainer(ComponentContainer parent) {
        super(parent);
    }

    @Override
    protected void doBeforeStart() {
        this.addPluginExtensions();
        this.addCoreComponents();
    }

    private void addCoreComponents() {
        this.add(StandalonePluginRulesLoader.class, new StandaloneRulesProvider(), RuleFinderCompatibility.class, XMLProfileParser.class, new StandaloneActiveRulesProvider());
    }

    private void addPluginExtensions() {
        this.getComponentByType(ExtensionInstaller.class).install(this, new RuleAndProfileExtensionFilter());
    }

    @Override
    public void doAfterStart() {
        this.rules = this.getComponentByType(Rules.class);
        this.activeRules = this.getComponentByType(ActiveRules.class);
        StandalonePluginRulesLoader offlineRulesLoader = this.getComponentByType(StandalonePluginRulesLoader.class);
        this.ruleDefinitions = offlineRulesLoader.getContext();
    }

    public Rules getRules() {
        return this.rules;
    }

    public ActiveRules getActiveRules() {
        return this.activeRules;
    }

    public RulesDefinition.Context getRulesDefinitions() {
        return this.ruleDefinitions;
    }

    static class RuleAndProfileExtensionFilter
    implements ExtensionMatcher {
        RuleAndProfileExtensionFilter() {
        }

        @Override
        public boolean accept(Object extension) {
            return ExtensionUtils.isType(extension, RulesDefinition.class) || ExtensionUtils.isType(extension, ProfileDefinition.class);
        }
    }
}

